/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ImageVideoWrapper;
import com.bumptech.glide.load.model.ModelLoader;
import java.io.InputStream;

public class ImageVideoModelLoader<A>
implements ModelLoader<A, ImageVideoWrapper> {
    private static final String TAG = "IVML";
    private final ModelLoader<A, InputStream> streamLoader;
    private final ModelLoader<A, ParcelFileDescriptor> fileDescriptorLoader;

    public ImageVideoModelLoader(ModelLoader<A, InputStream> streamLoader, ModelLoader<A, ParcelFileDescriptor> fileDescriptorLoader) {
        if (streamLoader == null && fileDescriptorLoader == null) {
            throw new NullPointerException("At least one of streamLoader and fileDescriptorLoader must be non null");
        }
        this.streamLoader = streamLoader;
        this.fileDescriptorLoader = fileDescriptorLoader;
    }

    @Override
    public DataFetcher<ImageVideoWrapper> getResourceFetcher(A model, int width, int height) {
        DataFetcher<InputStream> streamFetcher = null;
        if (this.streamLoader != null) {
            streamFetcher = this.streamLoader.getResourceFetcher(model, width, height);
        }
        DataFetcher<ParcelFileDescriptor> fileDescriptorFetcher = null;
        if (this.fileDescriptorLoader != null) {
            fileDescriptorFetcher = this.fileDescriptorLoader.getResourceFetcher(model, width, height);
        }
        if (streamFetcher != null || fileDescriptorFetcher != null) {
            return new ImageVideoFetcher(streamFetcher, fileDescriptorFetcher);
        }
        return null;
    }

    static class ImageVideoFetcher
    implements DataFetcher<ImageVideoWrapper> {
        private final DataFetcher<InputStream> streamFetcher;
        private final DataFetcher<ParcelFileDescriptor> fileDescriptorFetcher;

        public ImageVideoFetcher(DataFetcher<InputStream> streamFetcher, DataFetcher<ParcelFileDescriptor> fileDescriptorFetcher) {
            this.streamFetcher = streamFetcher;
            this.fileDescriptorFetcher = fileDescriptorFetcher;
        }

        @Override
        public ImageVideoWrapper loadData(Priority priority) throws Exception {
            ParcelFileDescriptor fileDescriptor;
            InputStream is;
            block9: {
                block8: {
                    is = null;
                    if (this.streamFetcher != null) {
                        try {
                            is = this.streamFetcher.loadData(priority);
                        }
                        catch (Exception e) {
                            if (Log.isLoggable((String)ImageVideoModelLoader.TAG, (int)2)) {
                                Log.v((String)ImageVideoModelLoader.TAG, (String)"Exception fetching input stream, trying ParcelFileDescriptor", (Throwable)e);
                            }
                            if (this.fileDescriptorFetcher != null) break block8;
                            throw e;
                        }
                    }
                }
                fileDescriptor = null;
                if (this.fileDescriptorFetcher != null) {
                    try {
                        fileDescriptor = this.fileDescriptorFetcher.loadData(priority);
                    }
                    catch (Exception e) {
                        if (Log.isLoggable((String)ImageVideoModelLoader.TAG, (int)2)) {
                            Log.v((String)ImageVideoModelLoader.TAG, (String)"Exception fetching ParcelFileDescriptor", (Throwable)e);
                        }
                        if (is != null) break block9;
                        throw e;
                    }
                }
            }
            return new ImageVideoWrapper(is, fileDescriptor);
        }

        @Override
        public void cleanup() {
            if (this.streamFetcher != null) {
                this.streamFetcher.cleanup();
            }
            if (this.fileDescriptorFetcher != null) {
                this.fileDescriptorFetcher.cleanup();
            }
        }

        @Override
        public String getId() {
            if (this.streamFetcher != null) {
                return this.streamFetcher.getId();
            }
            return this.fileDescriptorFetcher.getId();
        }

        @Override
        public void cancel() {
            if (this.streamFetcher != null) {
                this.streamFetcher.cancel();
            }
            if (this.fileDescriptorFetcher != null) {
                this.fileDescriptorFetcher.cancel();
            }
        }
    }
}

