package com.maplehaze.adsdk.demo;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;

import android.provider.Settings;
import android.view.View;
import android.widget.TextView;

import com.maplehaze.adsdk.MaplehazeSDK;
import com.maplehaze.adsdk.demo.utils.MhStatusBarUtil;
import com.maplehaze.adsdk.demo.utils.RestartUtl;
import com.maplehaze.adsdk.demo.utils.SharePfUtil;
import com.maplehaze.adsdk.demo.utils.ToastUtil;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends FragmentActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        MhStatusBarUtil.setStatusBarTranslucent(this);

        TextView appVersion = findViewById(R.id.app_version);
        appVersion.setText("app version: " + getAppVersion(this));
        TextView sdkVersion = findViewById(R.id.sdk_version);
        sdkVersion.setText("sdk version: " + MaplehazeSDK.getVersion());

        if (savedInstanceState!=null){
            RestartUtl.startClearLastTask(this);
        }else{
            if (Build.VERSION.SDK_INT >= 23) {
                checkAndRequestPermission();
            }
        }
        MaplehazeSDK.getInstance().setShowTouchTips(SharePfUtil.getTouchTipsConfig(this));
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.interstitialADButton:
                startActivity(new Intent(this, InterstitialActivity.class));
                break;
            case R.id.splashADButton:
                startActivity(new Intent(this, SplashAdActivity.class));
                break;
            case R.id.nativeADButton:
                startActivity(new Intent(this, NativeActivity.class));
                break;
            case R.id.rewardVideoADButton:
                startActivity(new Intent(this, RewardVideoActivity.class));
                break;

            case R.id.setting_iv:
                startActivity(new Intent(this, SettingActivity.class));
                break;
        }
    }

    //版本名
    public static String getAppVersion(Context context) {
        return getPackageInfo(context).versionName;
    }

    private static PackageInfo getPackageInfo(Context context) {
        PackageInfo pi = null;

        try {
            PackageManager pm = context.getPackageManager();
            pi = pm.getPackageInfo(context.getPackageName(),
                    PackageManager.GET_CONFIGURATIONS);

            return pi;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return pi;
    }

    @TargetApi(Build.VERSION_CODES.M)
    private void checkAndRequestPermission() {
        List<String> lackedPermission = new ArrayList<>();
        if (!(checkSelfPermission(android.Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(android.Manifest.permission.READ_PHONE_STATE);
        }

        if (!(checkSelfPermission(android.Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(android.Manifest.permission.WRITE_EXTERNAL_STORAGE);
        }

        if (!(checkSelfPermission(android.Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(Manifest.permission.ACCESS_FINE_LOCATION);
        }

        // 权限都已经有了，那么直接调用SDK
        if (lackedPermission.size() != 0) {
            // 请求所缺少的权限，在onRequestPermissionsResult中再看是否获得权限，如果获得权限就可以调用SDK，否则不要调用SDK。
            String[] requestPermissions = new String[lackedPermission.size()];
            lackedPermission.toArray(requestPermissions);
            requestPermissions(requestPermissions, 1024);
        }


    }

    private boolean hasAllPermissionsGranted(int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult == PackageManager.PERMISSION_DENIED) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1024 && hasAllPermissionsGranted(grantResults)) {
        } else {
            // 如果用户没有授权，那么应该说明意图，引导用户去设置里面授权。
            ToastUtil.showToast(getApplicationContext(), "应用缺少必要的权限！请点击\"权限\"，打开所需要的权限。");
            Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
            intent.setData(Uri.parse("package:" + getPackageName()));
            startActivity(intent);
            finish();
        }
    }

}
