package com.maplehaze.adsdk.demo;

import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.Nullable;

import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.TextView;

import com.maplehaze.adsdk.MaplehazeSDK;
import com.maplehaze.adsdk.demo.utils.MhStatusBarUtil;
import com.maplehaze.adsdk.demo.utils.RestartUtl;
import com.maplehaze.adsdk.demo.utils.SharePfUtil;
import com.maplehaze.adsdk.demo.utils.ToastUtil;

public class SettingActivity extends Activity {

    private TextView priceTv;
    private EditText priceEt;
    private Button savePrice;
    private int sdkVersionClickTimes = 0;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_setting);
        MhStatusBarUtil.setStatusBarTranslucent(this);
        initView();
        if (savedInstanceState!=null){
            RestartUtl.startClearLastTask(this);
        }
    }

    private void initView() {
        TextView sdkVersion = findViewById(R.id.sdk_version);
        sdkVersion.setText("sdk version: " + MaplehazeSDK.getVersion());
        View developModeLayout = findViewById(R.id.develop_mode_layout);
        Switch developModeSwitch = findViewById(R.id.develop_mode_switch);
        View touchToastLayout = findViewById(R.id.touch_toast_layout);
        Switch touchToastSwitch = findViewById(R.id.touch_toast_switch);
        sdkVersion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                sdkVersionClickTimes++;
                if (sdkVersionClickTimes > 5) {
                    developModeLayout.setVisibility(View.VISIBLE);
                    ToastUtil.showToast(getApplicationContext(), "开发者模式开启");
                    SharePfUtil.saveDevelopMode(getApplicationContext(), true);
                    developModeSwitch.setChecked(true);
                    touchToastLayout.setVisibility(View.VISIBLE);
                    touchToastSwitch.setChecked(SharePfUtil.getTouchTipsConfig(getApplicationContext()));

                }
            }
        });

        developModeSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                SharePfUtil.saveDevelopMode(getApplicationContext(), isChecked);
                MaplehazeSDK.getInstance().setDevelopMode(isChecked);
            }
        });
        boolean isDevelopMode = SharePfUtil.getDevelopMode(getApplicationContext());
        developModeSwitch.setChecked(isDevelopMode);

        if (isDevelopMode) {
            developModeLayout.setVisibility(View.VISIBLE);
            touchToastLayout.setVisibility(View.VISIBLE);
            touchToastSwitch.setChecked(SharePfUtil.getTouchTipsConfig(getApplicationContext()));
        } else {
            developModeLayout.setVisibility(View.GONE);
            touchToastLayout.setVisibility(View.GONE);
        }

        Switch ecpmSwitch = findViewById(R.id.ecpm_switch);
        ecpmSwitch.setChecked(SharePfUtil.getEcpmConfig(getApplicationContext()));
        ecpmSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                SharePfUtil.saveEcpmConfig(getApplicationContext(), isChecked);
            }
        });





        touchToastSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                SharePfUtil.saveTouchTipsConfig(getApplicationContext(), isChecked);
                MaplehazeSDK.getInstance().setShowTouchTips(isChecked);
            }
        });

        Switch toastSwitch = findViewById(R.id.toast_switch);
        toastSwitch.setChecked(SharePfUtil.getAdCallBackToastConfig(getApplicationContext()));
        toastSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                SharePfUtil.saveAdCallBackToastConfig(getApplicationContext(), isChecked);
            }
        });


        Switch apiDebugSwitch = findViewById(R.id.api_debug_switch);
        apiDebugSwitch.setChecked(MaplehazeSDK.getInstance().isServerEnvDebug());
        apiDebugSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                //仅测试环境，正式环境不要调用改方法
                MaplehazeSDK.getInstance().setServerEnvDebug(isChecked);
            }
        });


        priceTv = findViewById(R.id.bid_price_tv);
        priceEt = findViewById(R.id.bid_price_et);
        priceEt.setText(String.valueOf(SharePfUtil.getBiddingPrice(getApplicationContext())));
        savePrice = findViewById(R.id.bid_price_save_tv);
        savePrice.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (!TextUtils.isEmpty(priceEt.getText())) {
                    SharePfUtil.saveBiddingPrice(getApplicationContext(), Integer.valueOf(priceEt.getText().toString()));
                    ToastUtil.showToast(getApplicationContext(), "保存价格" + priceEt.getText());
                } else {
                    ToastUtil.showToast(getApplicationContext(), "请输入价格");
                }
            }
        });

        //兼容非竞价模式广告位
        Switch noBiddingCompatibilityModeSwitch = findViewById(R.id.no_bidding_compatibility_mode_switch);
        boolean isNoBidding = SharePfUtil.getNoBiddingCompatibilityModeSwitch(getApplicationContext());
        noBiddingCompatibilityModeSwitch.setChecked(isNoBidding);
        settNoBiddingStatus(isNoBidding);
        noBiddingCompatibilityModeSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                SharePfUtil.saveNoBiddingCompatibilityModeSwitch(getApplicationContext(), isChecked);
                settNoBiddingStatus(isChecked);
            }
        });


    }

    private void settNoBiddingStatus(boolean isChecked) {
        if (isChecked) {
            priceTv.setEnabled(false);
            savePrice.setEnabled(false);
            priceEt.setEnabled(false);
        } else {
            priceTv.setEnabled(true);
            savePrice.setEnabled(true);
            priceEt.setEnabled(true);
        }
    }


}
