package com.maplehaze.adsdk.demo;

import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.Nullable;

import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioGroup;

import com.maplehaze.adsdk.MaplehazeSDK;
import com.maplehaze.adsdk.bean.AdEffect;
import com.maplehaze.adsdk.demo.utils.RadioGroupUtil;
import com.maplehaze.adsdk.demo.utils.RestartUtl;
import com.maplehaze.adsdk.demo.utils.SharePfUtil;

public class SplashAdActivity extends Activity implements View.OnClickListener {

    private final static String TAG = "SplashAdActivity";

    private int mClickType = AdEffect.CLICK_TYPE_1;
    private RadioGroup mEffectGroup;
    private boolean isShowDownloadConfirm = false;
    private boolean isEnableServerConfig = false;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash_ad);

        this.findViewById(R.id.loadButton).setOnClickListener(this);
        this.findViewById(R.id.loadOnlyButton).setOnClickListener(this);
        mEffectGroup = findViewById(R.id.effect_group);
        ((EditText) findViewById(R.id.posId)).setText(Constants.SPLASH_POS_ID);

        CheckBox showDownloadConfirmCb = findViewById(R.id.showDownloadConfirmCb);
        showDownloadConfirmCb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                Log.i(TAG, "isShowDownloadConfirm option check: " + isChecked);
                isShowDownloadConfirm = isChecked;
            }
        });

        mEffectGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.normalRb) {
                    mClickType = AdEffect.CLICK_TYPE_1;//区域可点
                } else if (checkedId == R.id.slideRb) {
                    mClickType = AdEffect.CLICK_TYPE_2;//滑动
                } else if (checkedId == R.id.shakeRb) {
                    mClickType = AdEffect.CLICK_TYPE_3;//摇一摇
                } else if (checkedId == R.id.clickSlideshakeRb) {
                    mClickType = AdEffect.CLICK_TYPE_4;//点滑摇
                }

            }
        });

        if (!MaplehazeSDK.isSensor()){
            findViewById(R.id.shakeRb).setVisibility(View.GONE);
            findViewById(R.id.clickSlideshakeRb).setVisibility(View.GONE);
        }


        if (SharePfUtil.getDevelopMode(this)){
            isEnableServerConfig = true;
            showDownloadConfirmCb.setEnabled(false);
            RadioGroupUtil.setRadioGroupEnable(mEffectGroup, false);
        }

        if (savedInstanceState!=null){
            RestartUtl.startClearLastTask(this);
        }

    }

    private String getPosID() {
        String posId = ((EditText) findViewById(R.id.posId)).getText().toString();
        return TextUtils.isEmpty(posId) ? Constants.SPLASH_POS_ID : posId;
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.loadButton:
                SplashActivity.skipSplashActivity(this, false, mClickType, isShowDownloadConfirm, isEnableServerConfig, getPosID());
                break;
            case R.id.loadOnlyButton:
                SplashActivity.skipSplashActivity(this, true, mClickType, isShowDownloadConfirm, isEnableServerConfig, getPosID());

                break;
            default:
                break;
        }
    }
}
