package com.maplehaze.adsdk.demo;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.maplehaze.adsdk.MaplehazeAdConfig;
import com.maplehaze.adsdk.MaplehazeSDK;
import com.maplehaze.adsdk.demo.utils.OaidGetHelper;
import com.maplehaze.adsdk.demo.utils.ToastUtil;
import com.maplehaze.oaid.api.IGetterOaid;

public class StartActivity extends AppCompatActivity {
    private static final String TAG = "StartActivity";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_start);


        findViewById(R.id.sdk_start_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                initSdk();
                ToastUtil.showToast(StartActivity.this, R.string.mh_demo_sdk_init_with_start_msg);
            }
        });

        findViewById(R.id.sdk_show_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (MaplehazeSDK.getInstance().isInitWithoutStartFinish()) {
                    MaplehazeSDK.getInstance().start(new MaplehazeSDK.OnSdkStartListener() {
                        @Override
                        public void onSdkStartSuccess() {
                            ToastUtil.showToast(StartActivity.this, R.string.mh_demo_sdk_start_finish);
                            startActivity(new Intent(StartActivity.this, MainActivity.class));
                            finish();
                        }

                        @Override
                        public void onSdkStartFailed(Exception e) {
                            ToastUtil.showToast(StartActivity.this, R.string.mh_demo_sdk_start_fail);
                            startActivity(new Intent(StartActivity.this, MainActivity.class));
                            finish();
                        }
                    });

                } else {
                    ToastUtil.showToast(StartActivity.this, R.string.mh_demo_sdk_init_with_start_no_finish);
                }

            }
        });
    }


    private void initSdk() {
        MaplehazeAdConfig maplehazeAdConfig = new MaplehazeAdConfig();
        maplehazeAdConfig.setAppId(Constants.APP_ID);//设置appid
        //OAID必须传入，如果这里不传入。可以在后面MaplehazeSDK.getInstance().setOaid(oaid);
        //maplehazeAdConfig.setOaid(oaid);


        /////////////////配置可选//////////////////////////
        maplehazeAdConfig.setDebug(true);//log开关 true打开，false关闭(默认)
        maplehazeAdConfig.setShowDownloadToast(true); //下载应用是否有toast提醒开始下载
//        maplehazeAdConfig.setPersonalizedState(0);  // 0不屏蔽个性化推荐广告,1屏蔽个性化推荐广告
        /////////////////配置可选//////////////////////////
        //从 3.4.0 版本开始，SDK 初始化接口 MaplehazeSDK.getInstance().initWithoutStart()和 MaplehazeSDK.getInstance().start() 方法来完成 SDK 的初始化
        //同时保留了MaplehazeSDK.getInstance().init()
        MaplehazeSDK.getInstance().initWithoutStart(DemoApplication.getMyApplication(), maplehazeAdConfig);
        // MaplehazeSDK.getInstance().isInitFinish() 判断是否初始化完成
        // MaplehazeSDK.getVersion(); 获取sdk版本
    }
}
