package com.maplehaze.adsdk.demo.utils;

import android.view.View;
import android.view.ViewGroup;

public class AutoFitViewSizeUtil {


    public static void fitViewSize(View viewGroup, View view, int height, int width) {
        if (height == 0 || width == 0) {
            return;
        }
        float imageWHScale = (float) height / (float) width;
        if (imageWHScale < 1) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            int vw = view.getWidth() - view.getPaddingLeft() - view.getPaddingRight();
            int vh = Math.round(vw * imageWHScale);
            params.height = vh + view.getPaddingTop() + view.getPaddingBottom();
            params.width = vw;
            view.setLayoutParams(params);
        } else {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            int vw = viewGroup.getWidth() / 2 - view.getPaddingLeft() - view.getPaddingRight();
            int vh = Math.round(vw * imageWHScale);
            params.height = vh + view.getPaddingTop() + view.getPaddingBottom();
            params.width = vw;
            view.setLayoutParams(params);
        }
    }
}
