package com.maplehaze.adsdk.demo.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.maplehaze.adsdk.MaplehazeSDK;
import com.maplehaze.oaid.api.IGetterOaid;
import com.maplehaze.oaid.api.MhDeviceID;


public class OaidGetHelper {
    private static final String TAG = "OaidGetHelper";

    private OaidGetHelper() {
    }

    private static class Holder {
        private static final OaidGetHelper INSTANCE = new OaidGetHelper();
    }


    private static String oaidStr;

    public static OaidGetHelper getInstance() {
        return Holder.INSTANCE;  // 首次调用时加载内部类
    }

    public void initOaid(Context context) {
        try {


            if (TextUtils.isEmpty(oaidStr)){
                MhDeviceID.getOAID(context, new IGetterOaid() {
                    @Override
                    public void oaidSucc(String s) {
                        Log.e(TAG, "getOAID =" + s);
                        oaidStr = s;
                        if (!TextUtils.isEmpty(oaidStr)){
                            MaplehazeSDK.getInstance().setOaid(oaidStr);
                        }
                    }

                    @Override
                    public void oaidError(Exception e) {
                        Log.e(TAG, "getOAID Exception");

                    }
                });
            }


        } catch (Throwable e) {
            Log.e(TAG, "getOAID", e);
        }
    }

    public String getOaid() {
        return oaidStr;
    }
}
