package com.maplehaze.adsdk.demo.utils;


import android.content.Context;
import android.content.SharedPreferences;

public class SharePfUtil {

    public static String SPNAME = "sp_data";

    public static String KEY_OAID = "oaid";

    public static String KEY_ECPM_CFG = "is_show_ecpm";
    public static String KEY_TOUCH_TIPS= "is_show_touch_tips";


    public static String KEY_CALL_BACK_CFG = "is_show_ad_call_back";

    public static String KEY_NO_BIDDING_SWITCH = "no_bidding_compatibility_mode_switch";
    public static String KEY_BIDDING_PRICE = "bidding_price";
    public static String KEY_DEVELOP_MODE = "develop_mode";




    public static void saveOAID(Context context,String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(KEY_OAID, value);
    }


    public static String getOAID(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        return sharedPreferences.getString(KEY_OAID,"");
    }


    public static void saveEcpmConfig(Context context, boolean value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_ECPM_CFG, value);
        editor.apply();
    }

    public static boolean getEcpmConfig(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(KEY_ECPM_CFG, true);
    }



    public static void saveTouchTipsConfig(Context context, boolean value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_TOUCH_TIPS, value);
        editor.apply();
    }

    public static boolean getTouchTipsConfig(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(KEY_TOUCH_TIPS, false);
    }


    public static void saveAdCallBackToastConfig(Context context, boolean value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_CALL_BACK_CFG, value);
        editor.apply();
    }

    public static boolean getAdCallBackToastConfig(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(KEY_CALL_BACK_CFG, false);
    }




    public static void saveBiddingPrice(Context context, int value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_BIDDING_PRICE, value);
        editor.apply();
    }

    public static int getBiddingPrice(Context context) {
        int defValue=10;
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        return sharedPreferences.getInt(KEY_BIDDING_PRICE, defValue);
    }



    public static void saveNoBiddingCompatibilityModeSwitch(Context context, boolean value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_NO_BIDDING_SWITCH, value);
        editor.apply();
    }

    public static boolean getNoBiddingCompatibilityModeSwitch(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(KEY_NO_BIDDING_SWITCH, false);
    }



    public static void saveDevelopMode(Context context, boolean value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_DEVELOP_MODE, value);
        editor.apply();
    }

    public static boolean getDevelopMode(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SPNAME, Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(KEY_DEVELOP_MODE, false);
    }

}
